/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.IPAddress;
import com.cisco.pt.IPV6Address;
import com.cisco.pt.MACAddress;
import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPAddressImpl;
import com.cisco.pt.impl.IPV6AddressImpl;
import com.cisco.pt.impl.MACAddressImpl;
import com.cisco.pt.impl.UUIDImpl;
import java.nio.ByteBuffer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PtmpBuffer
implements EncodedBuffer {
    protected ByteBuffer buffer;
    protected boolean isTextMode = false;

    public PtmpBuffer(boolean isTextMode) {
        this(600000, isTextMode);
    }

    public PtmpBuffer(int size, boolean isTextMode) {
        this.buffer = ByteBuffer.allocate(size);
        this.isTextMode = isTextMode;
    }

    public boolean isTextMode() {
        return this.isTextMode;
    }

    public void dump(String name) {
        System.out.println(name + ".capacity = " + this.buffer.capacity());
        System.out.println(name + ".limit = " + this.buffer.limit());
        System.out.println(name + ".position = " + this.buffer.position());
        System.out.println(name + ".remaining = " + this.buffer.remaining());
    }

    @Override
    public byte[] copyRawBytes(boolean shouldFlip) {
        ByteBuffer bufferCopy = this.buffer.duplicate();
        byte[] bytes = new byte[bufferCopy.position()];
        if (shouldFlip) {
            bufferCopy.flip();
        }
        bufferCopy.get(bytes);
        return bytes;
    }

    @Override
    public byte[] getRawBytes() {
        byte[] bytes = null;
        if (this.buffer.limit() != this.buffer.capacity()) {
            this.buffer.compact();
        }
        bytes = new byte[this.buffer.position()];
        this.buffer.flip();
        this.buffer.get(bytes);
        this.buffer.clear();
        return bytes;
    }

    @Override
    public void setRawBytes(byte[] bytes) {
        this.buffer.clear();
        this.buffer.put(bytes);
        this.buffer.flip();
    }

    @Override
    public void clear() {
        this.buffer.clear();
    }

    @Override
    public int remaining() {
        return this.buffer.remaining();
    }

    @Override
    public void rewind() {
        this.buffer.rewind();
    }

    @Override
    public void flip() {
        this.buffer.flip();
    }

    @Override
    public boolean getBool() {
        if (this.isTextMode()) {
            return this.asBool(this.nextString());
        }
        byte b = this.buffer.get();
        return b != 0;
    }

    @Override
    public byte getByte() {
        if (this.isTextMode()) {
            return this.asByte(this.nextString());
        }
        return this.buffer.get();
    }

    @Override
    public byte getByteRaw() {
        return this.buffer.get();
    }

    @Override
    public char getChar() {
        if (this.isTextMode()) {
            return this.asChar(this.nextString());
        }
        return this.buffer.getChar();
    }

    @Override
    public double getDouble() {
        if (this.isTextMode()) {
            return this.asDouble(this.nextString());
        }
        return this.buffer.getDouble();
    }

    @Override
    public float getFloat() {
        if (this.isTextMode()) {
            return this.asFloat(this.nextString());
        }
        return this.buffer.getFloat();
    }

    @Override
    public int getInt() {
        if (this.isTextMode()) {
            return this.asInt(this.nextString());
        }
        return this.buffer.getInt();
    }

    @Override
    public IPAddress getIPAddress() {
        if (this.isTextMode()) {
            return this.asIPAddress(this.nextString());
        }
        byte[] ipBytes = new byte[4];
        this.buffer.get(ipBytes, 0, 4);
        return new IPAddressImpl(ipBytes);
    }

    @Override
    public IPV6Address getIPV6Address() {
        if (this.isTextMode()) {
            return this.asIPV6Address(this.nextString());
        }
        byte[] ipBytes = new byte[16];
        this.buffer.get(ipBytes, 0, 16);
        return new IPV6AddressImpl(ipBytes);
    }

    @Override
    public long getLong() {
        if (this.isTextMode()) {
            return this.asLong(this.nextString());
        }
        return this.buffer.getLong();
    }

    @Override
    public MACAddress getMACAddress() {
        if (this.isTextMode()) {
            return this.asMACAddress(this.nextString());
        }
        byte[] macBytes = new byte[6];
        this.buffer.get(macBytes, 0, 6);
        return new MACAddressImpl(macBytes);
    }

    @Override
    public short getShort() {
        if (this.isTextMode()) {
            return this.asShort(this.nextString());
        }
        return this.buffer.getShort();
    }

    @Override
    public String getString() {
        byte b;
        if (this.isTextMode()) {
            return this.nextString();
        }
        byte[] bytes = new byte[this.buffer.limit()];
        int index = 0;
        while (index < this.buffer.limit() && (b = this.buffer.get()) != 0) {
            bytes[index++] = b;
        }
        return new String(bytes, 0, index);
    }

    @Override
    public String peekString() {
        byte b;
        if (this.isTextMode()) {
            return this.peekNextString();
        }
        byte[] bytes = new byte[this.buffer.limit()];
        int index = 0;
        ByteBuffer temp = this.buffer.asReadOnlyBuffer();
        while (index < temp.limit() && (b = temp.get()) != 0) {
            bytes[index++] = b;
        }
        return new String(bytes, 0, index);
    }

    @Override
    public UUID getUUID() {
        if (this.isTextMode()) {
            return this.asUUID(this.nextString());
        }
        byte[] uuidBytes = new byte[16];
        this.buffer.get(uuidBytes, 0, 16);
        return new UUIDImpl(uuidBytes);
    }

    @Override
    public EncodedBuffer putBool(boolean b) {
        if (this.isTextMode()) {
            this.putString(this.asString(b));
        } else {
            this.buffer.put((byte)(b ? 1 : 0));
        }
        return this;
    }

    @Override
    public EncodedBuffer putByte(byte b) {
        if (this.isTextMode()) {
            this.putString(this.asString(b));
        } else {
            this.buffer.put(b);
        }
        return this;
    }

    @Override
    public EncodedBuffer putByteList(List<Byte> byteList) {
        this.putInt(byteList.size());
        for (Byte b : byteList) {
            this.buffer.put(b);
        }
        return this;
    }

    @Override
    public EncodedBuffer putChar(char c) {
        if (this.isTextMode()) {
            this.putString(this.asString(c));
        } else {
            this.buffer.putChar(c);
        }
        return this;
    }

    @Override
    public EncodedBuffer putDouble(double d) {
        if (this.isTextMode()) {
            this.putString(this.asString(d));
        } else {
            this.buffer.putDouble(d);
        }
        return this;
    }

    @Override
    public EncodedBuffer putFloat(float f) {
        if (this.isTextMode()) {
            this.putString(this.asString(f));
        } else {
            this.buffer.putFloat(f);
        }
        return this;
    }

    @Override
    public EncodedBuffer putInt(int i) {
        if (this.isTextMode()) {
            this.putString(this.asString(i));
        } else {
            this.buffer.putInt(i);
        }
        return this;
    }

    @Override
    public EncodedBuffer putIPAddress(IPAddress i) {
        if (this.isTextMode()) {
            this.putString(this.asString(i));
        } else {
            this.buffer.put(i.getByteArrayValue());
        }
        return this;
    }

    @Override
    public EncodedBuffer putIPV6Address(IPV6Address i) {
        if (this.isTextMode()) {
            this.putString(this.asString(i));
        } else {
            this.buffer.put(i.getByteArrayValue());
        }
        return this;
    }

    @Override
    public EncodedBuffer putLong(long l) {
        if (this.isTextMode()) {
            this.putString(this.asString(l));
        } else {
            this.buffer.putLong(l);
        }
        return this;
    }

    @Override
    public EncodedBuffer putMACAddress(MACAddress m) {
        if (this.isTextMode()) {
            this.putString(this.asString(m));
        } else {
            this.buffer.put(m.getByteArrayValue());
        }
        return this;
    }

    @Override
    public EncodedBuffer putShort(short s) {
        if (this.isTextMode()) {
            this.putString(this.asString(s));
        } else {
            this.buffer.putShort(s);
        }
        return this;
    }

    @Override
    public EncodedBuffer putString(String s) {
        if (this.isTextMode()) {
            for (int index = 0; index < s.length(); ++index) {
                this.buffer.put((byte)s.charAt(index));
            }
            this.buffer.put((byte)0);
        } else {
            this.buffer.put(s.getBytes());
            this.buffer.put((byte)0);
        }
        return this;
    }

    @Override
    public EncodedBuffer putStringAsBytes(byte[] bytes) {
        if (this.isTextMode()) {
            this.putString(this.asString(bytes));
        } else {
            this.buffer.put(bytes);
            this.buffer.put((byte)0);
        }
        return this;
    }

    @Override
    public EncodedBuffer putUUID(UUID u) {
        if (this.isTextMode()) {
            this.putString(this.asString(u));
        } else {
            this.buffer.put(u.getByteArrayValue());
        }
        return this;
    }

    protected String nextString() {
        byte[] bytes = new byte[this.buffer.limit()];
        int index = 0;
        while (index < this.buffer.limit()) {
            byte b = this.buffer.get();
            if (b != 0) {
                bytes[index++] = b;
                continue;
            }
            return new String(bytes, 0, index);
        }
        return new String(bytes, 0, index);
    }

    protected String peekNextString() {
        byte[] bytes = new byte[this.buffer.limit()];
        int index = 0;
        ByteBuffer temp = this.buffer.asReadOnlyBuffer();
        while (index < temp.limit()) {
            byte b = temp.get();
            if (b != 0) {
                bytes[index++] = b;
                continue;
            }
            return new String(bytes, 0, index);
        }
        return new String(bytes, 0, index);
    }

    protected boolean asBool(String s) {
        return s != null && s.equalsIgnoreCase("true");
    }

    protected byte asByte(String s) {
        byte answer = 0;
        try {
            answer = Byte.parseByte(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return answer;
    }

    protected char asChar(String s) {
        return s == null || s.length() == 0 ? (char)'\u0000' : s.charAt(0);
    }

    protected double asDouble(String s) {
        double answer = 0.0;
        try {
            answer = Double.parseDouble(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        return answer;
    }

    protected float asFloat(String s) {
        float answer = 0.0f;
        try {
            answer = Float.parseFloat(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return answer;
    }

    protected int asInt(String s) {
        int answer = 0;
        try {
            answer = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return answer;
    }

    protected IPAddress asIPAddress(String s) {
        IPAddressImpl answer = null;
        try {
            answer = new IPAddressImpl(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return answer;
    }

    protected IPV6Address asIPV6Address(String s) {
        IPV6AddressImpl answer = null;
        try {
            answer = new IPV6AddressImpl(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return answer;
    }

    protected long asLong(String s) {
        long answer = 0L;
        try {
            answer = Long.parseLong(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        return answer;
    }

    protected MACAddress asMACAddress(String s) {
        MACAddressImpl answer = null;
        try {
            answer = new MACAddressImpl(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return answer;
    }

    protected short asShort(String s) {
        short answer = 0;
        try {
            answer = Short.parseShort(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return answer;
    }

    protected UUID asUUID(String s) {
        UUIDImpl answer = null;
        try {
            answer = new UUIDImpl(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return answer;
    }

    protected String asString(boolean b) {
        return b ? "true" : "false";
    }

    protected String asString(byte b) {
        return String.valueOf(b);
    }

    protected String asString(byte[] bytes) {
        int size = bytes.length;
        char[] chars = new char[size];
        for (int index = 0; index < size; ++index) {
            chars[index] = (char)bytes[index];
        }
        return new String(chars);
    }

    protected String asString(char c) {
        return String.valueOf(c);
    }

    protected String asString(double d) {
        return String.valueOf(d);
    }

    protected String asString(float f) {
        return String.valueOf(f);
    }

    protected String asString(int i) {
        return String.valueOf(i);
    }

    protected String asString(IPAddress ip) {
        return ip.getDottedQuadString();
    }

    protected String asString(IPV6Address ip) {
        return ip.getColonHexString();
    }

    protected String asString(long l) {
        return String.valueOf(l);
    }

    protected String asString(MACAddress mac) {
        return mac.getDottedHexString();
    }

    protected String asString(short s) {
        return String.valueOf(s);
    }

    protected String asString(UUID uuid) {
        return uuid.getDecoratedHexString();
    }
}

